<?php
/**
 * Archivo de desinstalación del plugin Factunexo WooCommerce
 *
 * @package FactunexoWooCommerce
 */

// Si no se llama desde WordPress, salir
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Eliminar todas las opciones del plugin
delete_option('factunexo_wc_api_key');
delete_option('factunexo_wc_api_secret');
delete_option('factunexo_wc_api_url');
delete_option('factunexo_wc_invoice_trigger');
delete_option('factunexo_wc_pos_id');
delete_option('factunexo_wc_auto_create_items');
delete_option('factunexo_wc_auto_create_customers');

// Eliminar meta datos de pedidos
global $wpdb;
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_factunexo_%'");

// Limpiar transientes
delete_transient('factunexo_pos_catalog');
delete_transient('factunexo_api_status');

// Limpiar logs
$upload_dir = wp_upload_dir();
$log_dir = $upload_dir['basedir'] . '/wc-logs/';
$log_files = glob($log_dir . 'factunexo-*.log');

if ($log_files) {
    foreach ($log_files as $log_file) {
        unlink($log_file);
    }
}
