<?php
/**
 * Plugin Name: Factunexo WooCommerce Integration
 * Plugin URI: https://factunexo.com.ec
 * Description: Integración automática de facturación electrónica con Factunexo para WooCommerce
 * Version: 1.0.0
 * Author: Factunexo
 * Author URI: https://factunexo.com.ec
 * Text Domain: factunexo-woocommerce
 * Domain Path: /languages
 * Requires at least: 6.8
 * Tested up to: 6.8
 * WC requires at least: 8.0
 * WC tested up to: 10.0
 * Requires PHP: 7.4
 * WC_Tested_HPOS: true
 *
 * @package FactunexoWooCommerce
 */

// Prevenir acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// Verificar versión de PHP
if (version_compare(PHP_VERSION, '7.4.0', '<')) {
    add_action('admin_notices', 'factunexo_wc_php_version_notice');
    return;
}

// Definir constantes del plugin
define('FACTUNEXO_WC_VERSION', '1.0.0');
define('FACTUNEXO_WC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FACTUNEXO_WC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FACTUNEXO_WC_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Función para mostrar notificación de versión de PHP
function factunexo_wc_php_version_notice() {
    echo '<div class="notice notice-error"><p>';
    echo '<strong>Factunexo WooCommerce Integration:</strong> ';
    echo 'Este plugin requiere PHP 7.4 o superior. Tu versión actual es: <strong>' . PHP_VERSION . '</strong>. ';
    echo 'Por favor, contacta a tu proveedor de hosting para actualizar PHP.';
    echo '</p></div>';
}

// Verificar que WooCommerce esté activo
function factunexo_wc_check_wc_active() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', 'factunexo_wc_wc_missing_notice');
        return false;
    }
    return true;
}

// Función para mostrar notificación de WooCommerce faltante
function factunexo_wc_wc_missing_notice() {
    echo '<div class="notice notice-error"><p>';
    echo 'Factunexo WooCommerce Integration requiere que WooCommerce esté instalado y activado.';
    echo '</p></div>';
}

// Inicializar el plugin
function factunexo_wc_init() {
    if (!factunexo_wc_check_wc_active()) {
        return;
    }

    // Cargar archivos del plugin de forma segura
    $files_to_load = array(
        'includes/class-factunexo-api.php',
        'includes/class-factunexo-order-handler.php',
        'includes/class-factunexo-customer.php',
        'includes/class-factunexo-product.php',
        'includes/class-factunexo-invoice.php',
        'includes/class-factunexo-orders.php',
        'admin/class-factunexo-admin.php',
        'checkout/class-factunexo-checkout.php'
    );

    foreach ($files_to_load as $file) {
        $file_path = FACTUNEXO_WC_PLUGIN_DIR . $file;
        if (file_exists($file_path)) {
            require_once $file_path;
        }
    }

    // Inicializar clases principales de forma segura
    if (class_exists('Factunexo_Admin')) {
        new Factunexo_Admin();
    }
    if (class_exists('Factunexo_Checkout')) {
        new Factunexo_Checkout();
    }
    if (class_exists('Factunexo_Order_Handler')) {
        new Factunexo_Order_Handler();
    }
    if (class_exists('Factunexo_Orders')) {
        new Factunexo_Orders();
    }
}

// Hook de activación
register_activation_hook(__FILE__, 'factunexo_wc_activate');
function factunexo_wc_activate() {
    // Verificar versión de PHP
    if (version_compare(PHP_VERSION, '7.4.0', '<')) {
        wp_die(
            '<h1>Plugin no puede ser activado</h1>' .
            '<p>Factunexo WooCommerce Integration requiere PHP 7.4 o superior.</p>' .
            '<p>Tu versión actual es: <strong>' . PHP_VERSION . '</strong></p>' .
            '<p>Por favor, contacta a tu proveedor de hosting para actualizar PHP antes de activar el plugin.</p>',
            'Versión de PHP Incompatible',
            array('back_link' => true)
        );
    }
    
    // Crear opciones por defecto
    add_option('factunexo_wc_api_key', '');
    add_option('factunexo_wc_api_secret', '');
    add_option('factunexo_wc_api_url', 'https://api.factunexo.com');
    add_option('factunexo_wc_invoice_trigger', 'processing');
    add_option('factunexo_wc_pos_id', '');
    add_option('factunexo_wc_auto_create_items', 'yes');
    add_option('factunexo_wc_auto_create_customers', 'yes');
    
    // Flush rewrite rules
    flush_rewrite_rules();
}

// Hook de desactivación
register_deactivation_hook(__FILE__, 'factunexo_wc_deactivate');
function factunexo_wc_deactivate() {
    flush_rewrite_rules();
}

// Hook de desinstalación
register_uninstall_hook(__FILE__, 'factunexo_wc_uninstall');
function factunexo_wc_uninstall() {
    // Eliminar opciones del plugin
    delete_option('factunexo_wc_api_key');
    delete_option('factunexo_wc_api_secret');
    delete_option('factunexo_wc_api_url');
    delete_option('factunexo_wc_invoice_trigger');
    delete_option('factunexo_wc_pos_id');
    delete_option('factunexo_wc_auto_create_items');
    delete_option('factunexo_wc_auto_create_customers');
}

// Declarar compatibilidad con HPOS (High-Performance Order Storage)
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

// Inicializar cuando WordPress esté listo
add_action('plugins_loaded', 'factunexo_wc_init');

// Agregar enlaces de acción en la página de plugins
add_filter('plugin_action_links_' . FACTUNEXO_WC_PLUGIN_BASENAME, 'factunexo_wc_plugin_links');
function factunexo_wc_plugin_links($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=factunexo-settings') . '">' . __('Configuración', 'factunexo-woocommerce') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}

// Cargar traducciones
add_action('init', 'factunexo_wc_load_textdomain');
function factunexo_wc_load_textdomain() {
    load_plugin_textdomain('factunexo-woocommerce', false, dirname(FACTUNEXO_WC_PLUGIN_BASENAME) . '/languages');
}
